/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.global.history;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import kiwiapollo.cobblemontrainerbattle.CobblemonTrainerBattle;
import kiwiapollo.cobblemontrainerbattle.global.history.PlayerHistory;
import kiwiapollo.cobblemontrainerbattle.global.history.PlayerHistoryStorage;
import kiwiapollo.cobblemontrainerbattle.global.history.PlayerHistoryUtils;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.server.MinecraftServer;

public class PlayerHistorySaver
implements ServerLifecycleEvents.ServerStopped,
ServerTickEvents.EndTick {
    private static final int SAVE_INTERVAL = 24000;

    private void save(MinecraftServer server) {
        File historyPath = PlayerHistoryUtils.getHistoryPath(server);
        if (!historyPath.exists()) {
            historyPath.mkdirs();
        }
        for (Map.Entry<UUID, PlayerHistory> entry : PlayerHistoryStorage.getInstance().entrySet()) {
            try {
                UUID uuid = entry.getKey();
                PlayerHistory history = entry.getValue();
                File newHistory = new File(historyPath, String.format("%s.dat", uuid));
                File oldHistory = new File(historyPath, String.format("%s.dat_old", uuid));
                if (newHistory.exists()) {
                    newHistory.renameTo(oldHistory);
                }
                class_2507.method_30614((class_2487)history.writeToNbt(new class_2487()), (Path)newHistory.toPath());
            }
            catch (IOException e) {
                UUID uuid = entry.getKey();
                File file = new File(historyPath, String.format("%s.dat", uuid));
                CobblemonTrainerBattle.LOGGER.error("Error occurred while saving {}", (Object)file.getName());
            }
        }
        CobblemonTrainerBattle.LOGGER.info("Saved player histories");
    }

    public void onServerStopped(MinecraftServer server) {
        this.save(server);
    }

    public void onEndTick(MinecraftServer server) {
        if (server.method_3780() % 24000 == 0) {
            this.save(server);
        }
    }
}

